// =============================================
// SOLVO — Browser Spoof Content Script
// Runs at document_start in MAIN world to
// override all browser-identifying APIs BEFORE
// any page script can read them.
// =============================================

(() => {
  'use strict';

  // Guard against double-injection
  if (window.__solvoBrowserSpoofApplied) return;
  window.__solvoBrowserSpoofApplied = true;

  const CHROME_VER = '131';
  const CHROME_FULL_VER = '131.0.6778.139';
  const CHROME_UA = `Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/${CHROME_FULL_VER} Safari/537.36`;
  const CHROME_APP_VER = `5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/${CHROME_FULL_VER} Safari/537.36`;

  // ---- Helper: override on BOTH Navigator.prototype and navigator instance ----
  function overrideProp(obj, proto, prop, getter) {
    try {
      Object.defineProperty(proto, prop, { get: getter, configurable: true });
    } catch (e) {}
    try {
      Object.defineProperty(obj, prop, { get: getter, configurable: true });
    } catch (e) {}
  }

  // ---- Core navigator overrides ----
  overrideProp(navigator, Navigator.prototype, 'userAgent', () => CHROME_UA);
  overrideProp(navigator, Navigator.prototype, 'appVersion', () => CHROME_APP_VER);
  overrideProp(navigator, Navigator.prototype, 'vendor', () => 'Google Inc.');
  overrideProp(navigator, Navigator.prototype, 'platform', () => 'Win32');
  overrideProp(navigator, Navigator.prototype, 'productSub', () => '20030107');
  overrideProp(navigator, Navigator.prototype, 'webdriver', () => false);
  overrideProp(navigator, Navigator.prototype, 'languages', () => ['en-US', 'en']);
  overrideProp(navigator, Navigator.prototype, 'language', () => 'en-US');

  // ---- window.chrome object ----
  // On Edge/Brave/Opera, window.chrome exists but lacks Chrome-specific methods.
  // Always ensure csi, loadTimes, app exist.
  if (!window.chrome) window.chrome = {};
  if (!window.chrome.runtime) {
    window.chrome.runtime = {
      connect: function () { return { onMessage: { addListener: function () {} }, postMessage: function () {} }; },
      sendMessage: function () {},
    };
  }
  window.chrome.csi = function () {
    return { startE: Date.now(), onloadT: Date.now(), pageT: Date.now(), tran: 15 };
  };
  window.chrome.loadTimes = function () {
    return {
      commitLoadTime: Date.now() / 1000,
      connectionInfo: 'h2',
      finishDocumentLoadTime: Date.now() / 1000,
      finishLoadTime: Date.now() / 1000,
      firstPaintAfterLoadTime: Date.now() / 1000,
      firstPaintTime: Date.now() / 1000,
      navigationType: 'Other',
      npnNegotiatedProtocol: 'h2',
      requestTime: Date.now() / 1000 - 0.5,
      startLoadTime: Date.now() / 1000 - 1,
      wasAlternateProtocolAvailable: false,
      wasFetchedViaSpdy: true,
      wasNpnNegotiated: true,
    };
  };
  if (!window.chrome.app) {
    window.chrome.app = {
      isInstalled: false,
      InstallState: { DISABLED: 'disabled', INSTALLED: 'installed', NOT_INSTALLED: 'not_installed' },
      RunningState: { CANNOT_RUN: 'cannot_run', READY_TO_RUN: 'ready_to_run', RUNNING: 'running' },
    };
  }

  // ---- Remove Brave-specific detection ----
  try {
    if (navigator.brave) {
      delete Navigator.prototype.brave;
      delete navigator.brave;
    }
  } catch (e) {}
  try {
    Object.defineProperty(Navigator.prototype, 'brave', {
      get: () => undefined,
      configurable: true,
    });
  } catch (e) {}

  // ---- Remove Edge-specific detection ----
  try { delete window.MSStream; } catch (e) {}
  try { if (window.StyleMedia) delete window.StyleMedia; } catch (e) {}

  // ---- Remove Opera-specific detection ----
  try { if (window.opr) delete window.opr; } catch (e) {}
  try { if (window.opera) delete window.opera; } catch (e) {}

  // ---- navigator.userAgentData (UA Client Hints) ----
  const fakeUAData = {
    brands: [
      { brand: 'Chromium', version: CHROME_VER },
      { brand: 'Not_A Brand', version: '24' },
      { brand: 'Google Chrome', version: CHROME_VER },
    ],
    mobile: false,
    platform: 'Windows',
    getHighEntropyValues: (hints) =>
      Promise.resolve({
        architecture: 'x86',
        bitness: '64',
        brands: [
          { brand: 'Chromium', version: CHROME_FULL_VER },
          { brand: 'Not_A Brand', version: '24.0.0.0' },
          { brand: 'Google Chrome', version: CHROME_FULL_VER },
        ],
        fullVersionList: [
          { brand: 'Chromium', version: CHROME_FULL_VER },
          { brand: 'Not_A Brand', version: '24.0.0.0' },
          { brand: 'Google Chrome', version: CHROME_FULL_VER },
        ],
        mobile: false,
        model: '',
        platform: 'Windows',
        platformVersion: '15.0.0',
        uaFullVersion: CHROME_FULL_VER,
        wow64: false,
      }),
    toJSON: function () {
      return { brands: this.brands, mobile: this.mobile, platform: this.platform };
    },
  };
  overrideProp(navigator, Navigator.prototype, 'userAgentData', () => fakeUAData);

  // ---- navigator.plugins ----
  const fakePluginData = () => {
    const p = [
      { name: 'Chrome PDF Plugin', filename: 'internal-pdf-viewer', description: 'Portable Document Format' },
      { name: 'Chrome PDF Viewer', filename: 'mhjfbmdgcfjbbpaeojofohoefgiehjai', description: '' },
      { name: 'Native Client', filename: 'internal-nacl-plugin', description: '' },
    ];
    p.length = 3;
    p.item = (i) => p[i];
    p.namedItem = (name) => p.find((x) => x.name === name) || null;
    p.refresh = () => {};
    return p;
  };
  overrideProp(navigator, Navigator.prototype, 'plugins', fakePluginData);

  // ---- navigator.mimeTypes ----
  const fakeMimeData = () => {
    const m = [{ type: 'application/pdf', suffixes: 'pdf', description: 'Portable Document Format', enabledPlugin: null }];
    m.length = 1;
    m.item = (i) => m[i];
    m.namedItem = (name) => m.find((x) => x.type === name) || null;
    return m;
  };
  overrideProp(navigator, Navigator.prototype, 'mimeTypes', fakeMimeData);

  // ---- Patch Function.prototype.toString to hide overrides ----
  try {
    const nativeToString = Function.prototype.toString;
    Function.prototype.toString = function () {
      // If this function was an overridden getter, return native-looking string
      if (this.name === '' || this.name === 'get') {
        const str = nativeToString.call(this);
        if (str.includes('overrideProp') || str.includes('CHROME_') || str.includes('fakeUA')) {
          return 'function () { [native code] }';
        }
      }
      return nativeToString.call(this);
    };
  } catch (e) {}

  // ---- Prevent detection via iframe trick ----
  // Some sites create a temporary iframe and read navigator.userAgent from
  // the iframe's contentWindow. Override the HTMLIFrameElement.contentWindow
  // getter to also patch the iframe's navigator when accessed.
  try {
    const origContentWindow = Object.getOwnPropertyDescriptor(HTMLIFrameElement.prototype, 'contentWindow');
    if (origContentWindow && origContentWindow.get) {
      const origGet = origContentWindow.get;
      Object.defineProperty(HTMLIFrameElement.prototype, 'contentWindow', {
        get: function () {
          const win = origGet.call(this);
          if (win && !win.__solvoBrowserSpoofApplied) {
            try {
              win.__solvoBrowserSpoofApplied = true;
              const nav = win.navigator;
              const NavProto = win.Navigator.prototype;
              const define = (p, g) => {
                try { Object.defineProperty(NavProto, p, { get: g, configurable: true }); } catch (e) {}
                try { Object.defineProperty(nav, p, { get: g, configurable: true }); } catch (e) {}
              };
              define('userAgent', () => CHROME_UA);
              define('appVersion', () => CHROME_APP_VER);
              define('vendor', () => 'Google Inc.');
              define('platform', () => 'Win32');
              define('productSub', () => '20030107');
              define('userAgentData', () => fakeUAData);
              define('webdriver', () => false);
              define('languages', () => ['en-US', 'en']);
              define('language', () => 'en-US');
              // Patch window.chrome in iframe
              if (!win.chrome) win.chrome = {};
              win.chrome.csi = window.chrome.csi;
              win.chrome.loadTimes = window.chrome.loadTimes;
              if (!win.chrome.app) win.chrome.app = window.chrome.app;
              // Remove Brave/Edge/Opera in iframe
              try { delete win.navigator.brave; } catch (e) {}
              try { delete win.MSStream; } catch (e) {}
              try { delete win.opr; } catch (e) {}
              try { delete win.opera; } catch (e) {}
            } catch (e) {
              // Cross-origin iframe — can't patch, but HTTP headers will handle it
            }
          }
          return win;
        },
        configurable: true,
      });
    }
  } catch (e) {}

  // ---- Prevent detection via iframe contentDocument ----
  try {
    const origContentDocument = Object.getOwnPropertyDescriptor(HTMLIFrameElement.prototype, 'contentDocument');
    if (origContentDocument && origContentDocument.get) {
      const origDocGet = origContentDocument.get;
      Object.defineProperty(HTMLIFrameElement.prototype, 'contentDocument', {
        get: function () {
          // Trigger contentWindow patching first
          try { this.contentWindow; } catch (e) {}
          return origDocGet.call(this);
        },
        configurable: true,
      });
    }
  } catch (e) {}

  console.log(`[Solvo] Browser spoof applied (content script) — appearing as Google Chrome ${CHROME_VER}`);
})();
